using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.VisualStudio.TemplateWizard;
using System.Windows.Forms;

namespace WizardDemo
{
    public class MyFirstWizard : IWizard
    {
        private bool m_bCreateProjectItem = false;


        /// <summary>
        /// Runs custom wizard logic before opening an item in the template.
        /// </summary>
        /// <param name="projectItem">The project item that will be opened.</param>
        public void BeforeOpeningFile(EnvDTE.ProjectItem projectItem)
        {
        }

        /// <summary>
        /// Runs custom wizard logic when a project has finished generating.
        /// </summary>
        /// <param name="project">The project that finished generating.</param>
        public void ProjectFinishedGenerating(EnvDTE.Project project)
        {
        }

        /// <summary>
        /// Runs custom wizard logic when a project item has finished generating.
        /// </summary>
        /// <param name="projectItem">The project item that finished generating.</param>
        public void ProjectItemFinishedGenerating(EnvDTE.ProjectItem projectItem)
        {
        }

        /// <summary>
        /// Runs custom wizard logic when the wizard has completed all tasks.
        /// </summary>
        public void RunFinished()
        {
        }

        /// <summary>
        /// Runs custom wizard logic at the beginning of a template wizard run.
        /// </summary>
        /// <param name="automationObject">The automation object being used by the template wizard.</param>
        /// <param name="replacementsDictionary">The list of standard parameters to be replaced.</param>
        /// <param name="runKind">A <see cref="T:Microsoft.VisualStudio.TemplateWizard.WizardRunKind"></see> indicating the type of wizard run.</param>
        /// <param name="customParams">The custom parameters with which to perform parameter replacement in the project.</param>
        public void RunStarted(object automationObject, Dictionary<string, string> replacementsDictionary, WizardRunKind runKind, object[] customParams)
        {
            /*
            EnvDTE.DTE dteApplication = automationObject as EnvDTE.DTE;
            if (dteApplication == null)
                throw new NotSupportedException("Wizard is not running in the context of Visual Studio");
            */
            using (MyFirstWizardDialog dlgWizard = new MyFirstWizardDialog())
            {
                m_bCreateProjectItem = false;

                if (dlgWizard.ShowDialog() != DialogResult.OK)
                    return;

                replacementsDictionary["$Parameter1$"] = dlgWizard.Parameter1;
                replacementsDictionary["$Parameter2$"] = dlgWizard.Parameter2;
                replacementsDictionary["$Parameter3$"] = dlgWizard.Parameter3;
                m_bCreateProjectItem = true;
            }
        }

        /// <summary>
        /// Indicates whether the specified project item should be added to the project.
        /// </summary>
        /// <param name="filePath">The path to the project item.</param>
        /// <returns>
        /// true if the project item should be added to the project; otherwise, false.
        /// </returns>
        public bool ShouldAddProjectItem(string filePath)
        {
            return m_bCreateProjectItem;
        }
    }
}
